import socket
import time,random

class KM:
	def __init__(self,ip):
		self.sock = socket.socket(socket.AF_INET,socket.SOCK_DGRAM)
		self.sock.settimeout(1)
		self.ip=ip
		self.sync_mode=True
		
	def __del__(self):
		self.Close()
		
	def Close(self):
		if self.sock!=None:
			self.sock.close()
			self.sock=None
	
	def Send(self,msg):
		self.sock.sendto(msg.encode('ascii'),(self.ip,2333))
		
	def Recv(self):
		try:
			data,_ = self.sock.recvfrom(128)
			return data
		except socket.timeout:
			self.Close()
			self.sock = socket.socket(socket.AF_INET,socket.SOCK_DGRAM)
			self.sock.settimeout(1)
			return [0xff];
	
	def SendCmd(self,type,params):
		cmd=type+"="+",".join([str(s) for s in params])+"\r\n"
		self.Send(cmd)
		if self.sync_mode:
			return self.Recv()
		return None
	
	@staticmethod
	def Delay(millisecond):
		time.sleep(millisecond/1000)

	@staticmethod
	def DelayRandom(min,max):
		time.sleep(random.randint(min,max)/1000)
		
	def GetName(self):
		data=self.SendCmd("P",[0])
		if data[0]==0xff:
			return ""
		else:
			data=data[:data.index(0)]
			return data.decode("gbk")

	def GetID(self):
		data=self.SendCmd("P",[1])
		if len(data)!=4:
			return 0
		return data[0]<<24|data[1]<<16|data[2]<<8|data[3]
			
	#Setting
	def SetScreenRes(self,width,height):
		self.SendCmd("S",[0,width,height])

	def SetSpeedMode(self,on):
		self.sync_mode=not on
		self.SendCmd("S",[1,1 if on else 0])

	def Reboot(self):
		self.SendCmd("S",[2])


	#Mouse
	def MoveTo(self,x,y):
		self.SendCmd("M",[0,x,y])

	def MoveD(self,x,y,shift=0,time=0):
		self.SendCmd("M",[1,x,y,shift,time])

	def MoveR(self,dx,dy):
		self.SendCmd("M",[2,dx,dy])

	def LeftDown(self):
		self.SendCmd("M",[3])

	def LeftUp(self):
		self.SendCmd("M",[4])

	def LeftClick(self,min=0,max=0):
		self.SendCmd("M",[5,min,max])

	def LeftDoubleClick(self,min=0,max=0):
		self.SendCmd("M",[6,min,max])

	def RightDown(self):
		self.SendCmd("M",[7])

	def RightUp(self):
		self.SendCmd("M",[8])

	def RightClick(self,min=0,max=0):
		self.SendCmd("M",[9,min,max])

	def MouseWheel(self,delta):
		self.SendCmd("M",[10,delta])

	def MiddleDown(self):
		self.SendCmd("M",[11])

	def MiddleUp(self):
		self.SendCmd("M",[12])

	def MiddleClick(self,min=0,max=0):
		self.SendCmd("M",[13,min,max])

	def MouseAllUp(self):
		self.SendCmd("M",[14])


	#Keyboard
	def KeyDown(self,scancode):
		self.SendCmd("K",[0,scancode])

	def KeyUp(self,scancode):
		self.SendCmd("K",[1,scancode])

	def KeyPress(self,scancode,min=0,max=0):
		self.SendCmd("K",[2,scancode,min,max])

	def KeyDownVirtual(self,virtualcode):
		scancode=self.GetScanCodeFromVirtualCode(virtualcode)
		self.SendCmd("K",[0,scancode])

	def KeyUpVirtual(self,virtualcode):
		scancode=self.GetScanCodeFromVirtualCode(virtualcode)
		self.SendCmd("K",[1,scancode])

	def KeyPressVirtual(self,virtualcode,min=0,max=0):
		scancode=self.GetScanCodeFromVirtualCode(virtualcode)
		self.SendCmd("K",[2,scancode,min,max])

	def KeyDownName(self,keyname):
		scancode=self.GetScanCodeFromKeyName(keyname)
		self.SendCmd("K",[0,scancode])

	def KeyUpName(self,keyname):
		scancode=self.GetScanCodeFromKeyName(keyname)
		self.SendCmd("K",[1,scancode])

	def KeyPressName(self,keyname,min=0,max=0):
		scancode=self.GetScanCodeFromKeyName(keyname)
		self.SendCmd("K",[2,scancode,min,max])

	def KeyAllUp(self):
		self.SendCmd("K",[3])
	
	@staticmethod
	def GetScanCodeFromVirtualCode(vcode):
		keymap={
			"65":4,"66":5,"67":6,"68":7,"69":8,"70":9,"71":10,"72":11,"73":12,"74":13,"75":14,"76":15,"77":16,"78":17,"79":18,
			"80":19,"81":20,"82":21,"83":22,"84":23,"85":24,"86":25,"87":26,"88":27,"89":28,"90":29,"49":30,"50":31,"51":32,"52":33,
			"53":34,"54":35,"55":36,"56":37,"57":38,"48":39,"13":40,"27":41,"8":42,"9":43,"32":44,"189":45,"187":46,"219":47,"221":48,
			"220":49,"186":51,"222":52,"192":53,"188":54,"190":55,"191":56,"20":57,"112":58,"113":59,"114":60,"115":61,"116":62,"117":63,
			"118":64,"119":65,"120":66,"121":67,"122":68,"123":69,"44":70,"145":71,"19":72,"19":72,"45":73,"36":74,"33":75,"46":76,"35":77,
			"34":78,"39":79,"37":80,"40":81,"38":82,"144":83,"111":84,"96":85,"109":86,"107":87,"108":88,"97":89,"98":90,"99":91,"100":92,
			"101":93,"102":94,"103":95,"104":96,"105":97,"96":98,"110":99,"93":101,"146":103,"173":127,"175":128,"174":129,"162":224,"160":225,
			"164":226,"91":227,"163":228,"161":229,"165":230,"92":231,"17":224,"16":225,"18":226
		}
		vcode=str(vcode)
		if vcode in keymap:
			return keymap[vcode]
		else:
			return 0
	@staticmethod
	def GetScanCodeFromKeyName(keyname):
		keymap={
			"a":4,"b":5,"c":6,"d":7,"e":8,"f":9,"g":10,"h":11,"i":12,"j":13,"k":14,"l":15,"m":16,"n":17,"o":18,"p":19,"q":20,
			"r":21,"s":22,"t":23,"u":24,"v":25,"w":26,"x":27,"y":28,"z":29,"1":30,"2":31,"3":32,"4":33,"5":34,"6":35,"7":36,
			"8":37,"9":38,"0":39,"enter":40,"esc":41,"backspace":42,"tab":43,"space":44,"空格键":44,"-":45,"=":46,"[":47,"]":48,
			"\\":49,";":51,"'":52,"`":53,",":54,".":55,"/":56,"capslock":57,"f1":58,"f2":59,"f3":60,"f4":61,"f5":62,"f6":63,"f7":64,
			"f8":65,"f9":66,"f10":67,"f11":68,"f12":69,"printscreen":70,"scrolllock":71,"pause":72,"break":72,"insert":73,"home":74,
			"pageup":75,"delete":76,"end":77,"pagedown":78,"right":79,"left":80,"down":81,"up":82,"numlock":83,"小键盘/":84,"小键盘*":85,
			"小键盘-":86,"小键盘+":87,"小键盘enter":88,"小键盘1":89,"小键盘2":90,"小键盘3":91,"小键盘4":92,"小键盘5":93,"小键盘6":94,
			"小键盘7":95,"小键盘8":96,"小键盘9":97,"小键盘0":98,"小键盘.":99,"menu":101,"小键盘=":103,"静音":127,"音量加":128,"音量减":129,
			"lctrl":224,"lshift":225,"lalt":226,"lwin":227,"rctrl":228,"rshift":229,"ralt":230,"rwin":231,
			"ctrl":224,"shift":225,"alt":226,"win":227
		}
		keyname=keyname.lower()
		if keyname in keymap:
			return keymap[keyname]
		else:
			return 0
