import win32api,win32con
from km import KM

class MouseEvent():
    def mouse_move(x, y, main_screen_width, main_screen_height):
        dx = round(x*65536/main_screen_width)
        dy = round(y*65536/main_screen_height)
        win32api.mouse_event(win32con.MOUSEEVENTF_ABSOLUTE | win32con.MOUSEEVENTF_MOVE, dx, dy, 0, 0)
    def mouse_left_click():
        win32api.mouse_event(win32con.MOUSEEVENTF_LEFTDOWN | win32con.MOUSEEVENTF_LEFTUP, 0, 0, 0, 0)
    def mouse_left_dbclick():
        win32api.mouse_event(win32con.MOUSEEVENTF_LEFTDOWN | win32con.MOUSEEVENTF_LEFTUP, 0, 0, 0, 0)
        win32api.mouse_event(win32con.MOUSEEVENTF_LEFTDOWN | win32con.MOUSEEVENTF_LEFTUP, 0, 0, 0, 0)
    def mouse_right_click():
        win32api.mouse_event(win32con.MOUSEEVENTF_RIGHTDOWN | win32con.MOUSEEVENTF_RIGHTUP, 0, 0, 0, 0)
    def mouse_right_dbclick():
        win32api.mouse_event(win32con.MOUSEEVENTF_RIGHTDOWN | win32con.MOUSEEVENTF_RIGHTUP, 0, 0, 0, 0)
        win32api.mouse_event(win32con.MOUSEEVENTF_RIGHTDOWN | win32con.MOUSEEVENTF_RIGHTUP, 0, 0, 0, 0)
    def mouse_middle_up():
        win32api.mouse_event(win32con.MOUSEEVENTF_WHEEL, 0, 0, 100, 0)
    def mouse_middle_down():
        win32api.mouse_event(win32con.MOUSEEVENTF_WHEEL, 0, 0, -100, 0)
    def mouse_left_down():
        win32api.mouse_event(win32con.MOUSEEVENTF_LEFTDOWN, 0, 0, 0, 0)
    def mouse_left_up():
        win32api.mouse_event(win32con.MOUSEEVENTF_LEFTUP, 0, 0, 0, 0)
    def mouse_right_down():
        win32api.mouse_event(win32con.MOUSEEVENTF_RIGHTDOWN, 0, 0, 0, 0)
    def mouse_right_up():
        win32api.mouse_event(win32con.MOUSEEVENTF_RIGHTUP, 0, 0, 0, 0)


class RemoteMouseEvent():
    #def __init__(self, sip1, sip2, main_screen_width, main_screen_height):
    def __init__(self, sip1):
        self.cx = None
        self.cy = None
        self.km1 = KM(sip1)

    def setScreenRes(self, width, height):
        self.km1.SetScreenRes(width, height)
    
    def setSpeedMode(self, on):
        self.km1.SetSpeedMode(on)

    def _update(self, x, y):
        self.x = int(x)
        self.y = int(y)

    def get_km(self):
        return self.km1
        #print(self.x, self.y, self.main_screen_width, self.main_screen_height)
        #if self.x is None or self.main_screen_width is None:
            #return None
        #return self.km1 if self.x < self.main_screen_width else self.km2

    def mouse_move(self, x, y, main_screen_width, main_screen_height):
        self._update(x, y)
        km = self.get_km()
        km.MoveTo(int(x), int(y))

    def mouse_left_click(self):
        km = self.get_km()
        km.LeftClick()

    def mouse_left_dbclick(self):
        km = self.get_km()
        km.LeftDoubleClick()

    def mouse_right_click(self):
        km = self.get_km()
        km.RightClick()

    def mouse_right_dbclick(self):
        km = self.get_km()
        km.RightClick()
        km.RightClick()

    def mouse_wheel_up(self):
        km = self.get_km()
        km.MouseWheel(2)

    def mouse_wheel_down(self):
        km=self.get_km()
        km.MouseWheel(-2)

    def mouse_middle_up(self):
        km = self.get_km()
        km.MiddleUp()

    def mouse_middle_down(self):
        km = self.get_km()
        km.MiddleDown()

    def mouse_left_down(self):
        km = self.get_km()
        km.LeftDown()

    def mouse_left_up(self):
        km = self.get_km()
        km.LeftUp()

    def mouse_right_down(self):
        km = self.get_km()
        km.RightDown()

    def mouse_right_up(self):
        km = self.get_km()
        km.RightUp()


class MultiScreenMouseEvent():
    def __init__(self, screen_width, screen_height, layout, speed_mode = True) -> None:
        self.total_screen_width = screen_width
        self.total_screen_height = screen_height
        self.layout = layout
        self.speed_mode = speed_mode
        self.kms = {}
        for s in self.layout:
            km = KM(s["ip"])
            km.SetScreenRes(s["width"], s["height"])
            km.SetSpeedMode(speed_mode)
            self.kms[s["id"]] = km
        self.current_screen = None

    def find_screen_and_relative_coords(self, point):
        for screen in self.layout:
            x, y = point
            anchor_x, anchor_y = screen['anchor']
            width, height = screen['width'], screen['height']
            if anchor_x <= x < anchor_x + width and anchor_y <= y < anchor_y + height:
                #relative_coords = [x, y - anchor_y]
                relative_coords = [x - anchor_x, y - anchor_y]
                return screen, relative_coords
        return None, None

    def __getattr__(self, name):
        if name == "mouse_move":
            def method(ax, ay):
                s, coords = self.find_screen_and_relative_coords((ax, ay))
                km = self.kms[s["id"]]
                self.current_screen = s["id"]
                #self.current_screen = "screen1"
                rx, ry = coords[0], coords[1]
                print(self.current_screen, int(rx), int(ry))
                km.MoveTo(int(rx), int(ry))
            return method
        else:
            def method(*args, **kwargs):
                km = self.kms[self.current_screen]
                getattr(km, name)(*args, **kwargs)
            return method