# -*- coding: utf-8 -*-
import numpy as np
import cv2
from mm_event_mouse import MouseEvent
# from pymouse import PyMouse
from mm_gige import GigeE
from mm_cursor_hider import CursorHider
from win32 import win32api, win32gui, win32print
from win32.lib import win32con
from mm_mouse_filter import WeightedMovingAverageFilter
#import time

gl_cam_running = False
class MouseVideo():

    #def start_mouse_follow(callback, pts1, pts2, point_area, video_size, light, show_frame,
    #                    is_mouse_follow, process_ratio, monitor_ratio, is_merge, mousehandler=None):

    def start_mouse_follow(callback, pts1, pts2, point_area, video_size, light, show_frame,
                        is_mouse_follow, process_ratio, monitor_ratio, screen_width, screen_height, mousehandler=None):
        filter = WeightedMovingAverageFilter(weights=[0.8,0.1,0.1,0,0], disabled=False, threshold=0.90)


        perspective1,maxWidth1,maxHeight1 = MouseVideo.get_perspective(pts1)
        perspective2,maxWidth2,maxHeight2 = MouseVideo.get_perspective(pts2)

        #hDC = win32gui.GetDC(0)
        #main_screen_width = win32print.GetDeviceCaps(hDC, win32con.DESKTOPHORZRES)
        #main_screen_height = win32print.GetDeviceCaps(hDC, win32con.DESKTOPVERTRES)
        #screen_num = win32api.GetSystemMetrics(win32con.SM_CMONITORS);

        #screen_width = main_screen_width if is_merge else main_screen_width * screen_num;
        #screen_height = main_screen_height;

        #screen_width = screen_size[0]
        #screen_height = screen_size[1]
        video_width = video_size[0]
        video_height = video_size[1]
        # mouse = PyMouse()
        pX = -1
        pY = -1
        #error = []
        min_area = point_area[0]
        max_area = point_area[1]
        process = 1
        count = 0

        cam1 = GigeE.startCamera(0)
        cam2 = GigeE.startCamera(1)

        if cam1 == None or cam2 == None:
            callback(False)
            return
        
        #i = 0
        callback(True)
        #CursorHider.cursor_hider_open()
        global gl_cam_running
        gl_cam_running = True
        while (gl_cam_running):
            count = count + process_ratio
            if count >= 1:
                count = count - 1
                
                img1 = GigeE.GetImage(cam1, video_height, video_width)
                img1 = cv2.warpPerspective(img1, perspective1, (maxWidth1, maxHeight1))
                img1 = cv2.resize(img1,(round(screen_width/2), screen_height))
                
                img2 = GigeE.GetImage(cam2, video_height, video_width)
                img2 = cv2.warpPerspective(img2, perspective2, (maxWidth2, maxHeight2))
                img2 = cv2.resize(img2,(round(screen_width/2), screen_height))

                img = np.hstack([img1, img2])
                
                #i=i+1
                #cv2.imwrite("./img_join/img_join_"+str(i)+'.png',img)
                
                img = cv2.cvtColor(img, cv2.COLOR_BayerBG2BGR)
                img = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY) #Color to grayscale))
                #sp = img.shape
                #frame_height,frame_width = sp[:2]
                #img = cv2.medianBlur(img,5) #median filtering
                ret,thresh = cv2.threshold(img,light,255,0)   #Binarization
                image,contours,hierarchy = cv2.findContours(thresh, cv2.RETR_TREE, cv2.CHAIN_APPROX_NONE)
                
                if show_frame == True:
                    #cv2.drawContours(img,contours,-1,(255,255,0),15)
                    new_img = cv2.resize(img,(round(screen_width/2), round(screen_height/2)))
                    cv2.imshow("mouse_move", new_img)

                found_cnt = None
                processable = True
                for cnt in contours:
                    area = cv2.contourArea(cnt)
                    if area <= max_area and area >= min_area:
                        if found_cnt is not None:
                            print("error: found multiple point, skip!")
                            processable = False
                            break
                        found_cnt = cnt

                #if len(contours) != 1:
                #    print(len(contours))
                if processable == True and found_cnt is not None:
                    M = cv2.moments(found_cnt)
                    if M["m00"] != 0:
                        cX = int(M["m10"]/M["m00"])   #Calculate the centroid
                        cX = int(cX + (cX - screen_width/2)*monitor_ratio)
                        #cX = int(cX + (cX - screen_width)*monitor_ratio)
                        if cX < 0:
                            cX = 0
                        if cX > screen_width:
                            cX = screen_width
                        cY = int(M["m01"]/M["m00"])
                        cY = int(cY + (cY - screen_height/2)*monitor_ratio)
                        #cY = int(cY + (cY - screen_height)*monitor_ratio)
                        if cY < 0:
                            cY = 0
                        if cY > screen_height:
                            cY = screen_height
                    
                        if pX != cX or pY != cY:
                            pX = cX
                            pY = cY
                            #print("x:", round(cX*screen_width/frame_width), ", y:", round(cY*screen_height/frame_height))
                            if is_mouse_follow == True:
                                points = filter.update((cX, cY))
                                #MouseEvent.mouse_move(points[0], points[1], main_screen_width, main_screen_height)
                                if mousehandler is not None:
                                    mousehandler.mouse_move(points[0], points[1])
                            
            if cv2.waitKey(10) & 0xFF == ord('q'):
                break
        GigeE.closeCamera(cam1)
        GigeE.closeCamera(cam2)
        cv2.destroyAllWindows()

    def stop_mouse_follow():
        global gl_cam_running
        if gl_cam_running == True:
            #CursorHider.cursor_hider_close()
            gl_cam_running = False

    def is_running():
        global gl_cam_running
        return gl_cam_running

    def get_perspective(pts):
        rect = MouseVideo.order_points(pts)
        (tl, tr, br, bl) = rect

        widthA = np.sqrt(((br[0] - bl[0]) ** 2) + ((br[1] - bl[1]) ** 2))
        widthB = np.sqrt(((tr[0] - tl[0]) ** 2) + ((tr[1] - tl[1]) ** 2))
        maxWidth = max(int(widthA), int(widthB))

        heightA = np.sqrt(((tr[0] - br[0]) ** 2) + ((tr[1] - br[1]) ** 2))
        heightB = np.sqrt(((tl[0] - bl[0]) ** 2) + ((tl[1] - bl[1]) ** 2))
        maxHeight = max(int(heightA), int(heightB))

        dst = np.array([
            [0, 0],
            [maxWidth - 1, 0],
            [maxWidth - 1, maxHeight - 1],
            [0, maxHeight - 1]], dtype = "float32")

        perspective = cv2.getPerspectiveTransform(rect, dst)
        return perspective,maxWidth,maxHeight
        
    def order_points(pts):
        rect = np.zeros((4, 2), dtype = "float32")

        s = pts.sum(axis = 1)
        rect[0] = pts[np.argmin(s)]
        rect[2] = pts[np.argmax(s)]

        diff = np.diff(pts, axis = 1)
        rect[1] = pts[np.argmin(diff)]
        rect[3] = pts[np.argmax(diff)]

        return rect
