# -*- coding: utf-8 -*-
import numpy as np
import cv2
import imutils
import time
from pymouse import PyMouse
import win32api,win32con
from configparser import ConfigParser
from mm_gige import GigeE

def start_mouse_follow(pts, video_url, point_area, screen_size, video_size, show_frame,
                       is_mouse_follow, process_ratio, monitor_ratio):
    perspective1,maxWidth1,maxHeight1 = get_perspective(pts1)
    perspective2,maxWidth2,maxHeight2 = get_perspective(pts2)

    #screen_width = win32api.GetSystemMetrics(win32con.SM_CXSCREEN)
    #screen_height = win32api.GetSystemMetrics(win32con.SM_CYSCREEN)
    screen_width = screen_size[0]
    screen_height = screen_size[1]
    video_width = video_size[0]
    video_height = video_size[1]
    mouse = PyMouse()
    pX = -1
    pY = -1
    #error = []
    min_area = point_area[0]
    max_area = point_area[1]
    process = 1
    count = 0


    cam1 = GigeE.startCamera(0)
    cam2 = GigeE.startCamera(1)
    
    keyValue = 0
    i = 0
    while keyValue != ord('q'):



        count = count + process_ratio
        if count >= 1:
            count = count - 1
            
            frame1 = GigeE.GetImage(cam1, video_height, video_width)
            frame1 = cv2.cvtColor(frame1, cv2.COLOR_BayerBG2BGR)
            
            frame2 = GigeE.GetImage(cam2, video_height, video_width)
            frame2 = cv2.cvtColor(frame2, cv2.COLOR_BayerBG2BGR)
            
            i=i+1
            cv2.imwrite("./img/img1_"+str(i)+'.png',frame1)
            cv2.imwrite("./img/img2_"+str(i)+'.png',frame2)




        
        # cv2.waitKey(10)  # time.sleep 延时没有用
        keyValue = cv2.waitKey(10)

    
    cv2.destroyAllWindows()
    GigeE.closeCamera(cam1)
    keyValue = cv2.waitKey()
    cv2.destroyAllWindows()
    



def create_cap(video_url, video_width, video_height):
    cap = cv2.VideoCapture(video_url)
    cap.set(cv2.CAP_PROP_FOURCC, cv2.VideoWriter_fourcc('M', 'J', 'P', 'G'))
    cap.set(cv2.CAP_PROP_FRAME_WIDTH, video_width)
    cap.set(cv2.CAP_PROP_FRAME_HEIGHT, video_height)
    #cap.set(cv2.CAP_PROP_BUFFERSIZE, 3)
    #cap.set(cv2.CAP_PROP_FPS, 30)
    return cap
    
def order_points(pts):
    rect = np.zeros((4, 2), dtype = "float32")

    s = pts.sum(axis = 1)
    rect[0] = pts[np.argmin(s)]
    rect[2] = pts[np.argmax(s)]

    diff = np.diff(pts, axis = 1)
    rect[1] = pts[np.argmin(diff)]
    rect[3] = pts[np.argmax(diff)]

    return rect

def perspective_transformation(img):
    gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)
    blurred = cv2.GaussianBlur(gray, (5, 5), 0)
    dilate = cv2.dilate(blurred, cv2.getStructuringElement(cv2.MORPH_RECT, (3, 3)))
    # edged = cv2.Canny(dilate, 75, 200)
    edged = cv2.Canny(dilate, 30, 120, 3)

    cnts = cv2.findContours(edged.copy(), cv2.RETR_EXTERNAL, cv2.CHAIN_APPROX_SIMPLE)
    cnts = cnts[0] if imutils.is_cv2() else cnts[1]
    screen_cnt = None

    if len(cnts) > 0:
        cnts = sorted(cnts, key=cv2.contourArea, reverse=True)
        for c in cnts:
            peri = cv2.arcLength(c, True)
            approx = cv2.approxPolyDP(c, 0.02 * peri, True)
            if len(approx) == 4:
                screen_cnt = approx
                break
    return screen_cnt

if __name__ == "__main__":
    cf = ConfigParser()
    cf.read('config.ini', encoding='utf-8')
    show_frame = cf.get('video', 'is_show')
    video_size = json.loads(cf.get('video', 'size'))
    point_area = json.loads(cf.get('point', 'area'))
    point_light = cf.get('point', 'light')
    mouse_follow = cf.get('point', 'is_mouse_follow')
    fps_ratio = cf.get('point', 'fps_ratio')
    monitor_ratio = cf.get('point', 'monitor_ratio')
    screen_size = json.loads(cf.get('screen', 'size'))
    is_show_frame = int(show_frame) == 1
    is_mouse_follow = int(mouse_follow) == 1
    process_ratio = float(fps_ratio)
    monitor_ratio = float(monitor_ratio)
    light = int(point_light)
    if process_ratio > 1:
        process_ratio = 1
    pts1 = np.array(json.loads(cf.get('correct', 'position1')))
    pts2 = np.array(json.loads(cf.get('correct', 'position2')))
    start_mouse_follow(pts1, pts2, point_area, screen_size, video_size, light,
                       is_show_frame, is_mouse_follow, process_ratio, monitor_ratio)
