# -*- coding: utf-8 -*-
import numpy as np
import cv2
import imutils
from pymouse import PyMouse
import win32api,win32con
from configparser import ConfigParser
from mm_gige import GigeE
import json
import time

def start_mouse_follow(pts1, pts2, point_area, screen_size, video_size, show_frame,
                       is_mouse_follow, process_ratio, monitor_ratio):

    perspective1,maxWidth1,maxHeight1 = get_perspective(pts1)
    perspective2,maxWidth2,maxHeight2 = get_perspective(pts2)

    #screen_width = win32api.GetSystemMetrics(win32con.SM_CXSCREEN)
    #screen_height = win32api.GetSystemMetrics(win32con.SM_CYSCREEN)
    screen_width = screen_size[0]
    screen_height = screen_size[1]
    video_width = video_size[0]
    video_height = video_size[1]
    mouse = PyMouse()
    pX = -1
    pY = -1
    #error = []
    min_area = point_area[0]
    max_area = point_area[1]
    process = 1
    count = 0


    cam1 = GigeE.startCamera(0)
    cam2 = GigeE.startCamera(1)
    i = 0
    while (True):
        count = count + process_ratio
        if count >= 1:
            count = count - 1
            

            img1 = GigeE.GetImage(cam1, video_height, video_width)
            img1 = cv2.warpPerspective(img1, perspective1, (maxWidth1, maxHeight1))
            img1 = cv2.resize(img1,(round(screen_width/2), screen_height))
            
            img2 = GigeE.GetImage(cam2, video_height, video_width)
            img2 = cv2.warpPerspective(img2, perspective2, (maxWidth2, maxHeight2))
            img2 = cv2.resize(img2,(round(screen_width/2), screen_height))

            
            img = np.hstack([img1, img2])
            
            img = cv2.cvtColor(img, cv2.COLOR_BayerBG2BGR)
            img = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY) #Color to grayscale))
            #sp = img.shape
            #frame_height,frame_width = sp[:2]
            #img = cv2.medianBlur(img,5) #median filtering
            ret,thresh = cv2.threshold(img,20,255,0)   #Binarization
            image,contours,hierarchy = cv2.findContours(thresh, cv2.RETR_TREE, cv2.CHAIN_APPROX_NONE)
            cv2.drawContours(img,contours,-1,(255,255,0),15)

            img = cv2.resize(img,(round(screen_width/2), round(screen_height/2)))
            cv2.imshow("mouse_move", img)

        if cv2.waitKey(10) & 0xFF == ord('q'):
            break
    GigeE.closeCamera(cam1)
    GigeE.closeCamera(cam2)
    cv2.destroyAllWindows()
    

def get_perspective(pts):
    rect = order_points(pts)
    (tl, tr, br, bl) = rect

    widthA = np.sqrt(((br[0] - bl[0]) ** 2) + ((br[1] - bl[1]) ** 2))
    widthB = np.sqrt(((tr[0] - tl[0]) ** 2) + ((tr[1] - tl[1]) ** 2))
    maxWidth = max(int(widthA), int(widthB))

    heightA = np.sqrt(((tr[0] - br[0]) ** 2) + ((tr[1] - br[1]) ** 2))
    heightB = np.sqrt(((tl[0] - bl[0]) ** 2) + ((tl[1] - bl[1]) ** 2))
    maxHeight = max(int(heightA), int(heightB))

    dst = np.array([
        [0, 0],
        [maxWidth - 1, 0],
        [maxWidth - 1, maxHeight - 1],
        [0, maxHeight - 1]], dtype = "float32")

    perspective = cv2.getPerspectiveTransform(rect, dst)
    return perspective,maxWidth,maxHeight
    
def order_points(pts):
    rect = np.zeros((4, 2), dtype = "float32")

    s = pts.sum(axis = 1)
    rect[0] = pts[np.argmin(s)]
    rect[2] = pts[np.argmax(s)]

    diff = np.diff(pts, axis = 1)
    rect[1] = pts[np.argmin(diff)]
    rect[3] = pts[np.argmax(diff)]

    return rect

if __name__ == "__main__":
    cf = ConfigParser()
    cf.read('config.ini', encoding='utf-8')
    show_frame = cf.get('video', 'is_show')
    video_size = json.loads(cf.get('video', 'size'))
    point_area = json.loads(cf.get('point', 'area'))
    mouse_follow = cf.get('point', 'is_mouse_follow')
    fps_ratio = cf.get('point', 'fps_ratio')
    monitor_ratio = cf.get('point', 'monitor_ratio')
    screen_size = json.loads(cf.get('screen', 'size'))
    is_show_frame = int(show_frame) == 1
    is_mouse_follow = int(mouse_follow) == 1
    process_ratio = float(fps_ratio)
    monitor_ratio = float(monitor_ratio)
    if process_ratio > 1:
        process_ratio = 1
    pts1 = np.array(json.loads(cf.get('correct', 'position1')))
    pts2 = np.array(json.loads(cf.get('correct', 'position2')))
    start_mouse_follow(pts1, pts2, point_area, screen_size, video_size,
                       is_show_frame, is_mouse_follow, process_ratio, monitor_ratio)
    
