# -*- coding: utf-8 -*-
import numpy as np
from configparser import ConfigParser
import json
import ctypes

import tkinter
from tkinter import *
import keyboard
import inspect

from ctypes import cast, POINTER
from comtypes import CLSCTX_ALL
import pythoncom
from pycaw.pycaw import AudioUtilities, IAudioEndpointVolume

from mm_video import MouseVideo
from mm_udp_service import UdpService
from mm_event_mouse import MouseEvent
from mm_event_remote_mouse import RemoteMouseEvent, MultiScreenMouseEvent
import datetime
from threading import Thread

MOUSEHANDLER = None

def volume_change():
    pythoncom.CoInitialize()
    devices = AudioUtilities.GetSpeakers()
    interface = devices.Activate(IAudioEndpointVolume._iid_, CLSCTX_ALL, None)
    volume = cast(interface, POINTER(IAudioEndpointVolume))
    # 判断是否静音，mute为1代表是静音，为0代表不是静音
    mute = volume.GetMute()
    if mute == 0:
        volume.SetMute(1, None)
    else:
        volume.SetMute(0, None)

def start_open_point():
    cfg = ConfigParser()
    cfg.read('config.ini', encoding='utf-8')
    show_frame = cfg.get('video', 'is_show')
    video_size = json.loads(cfg.get('video', 'size'))
    point_area = json.loads(cfg.get('point', 'area'))
    point_light = cfg.get('point', 'light')
    mouse_follow = cfg.get('point', 'is_mouse_follow')
    fps_ratio = cfg.get('point', 'fps_ratio')
    monitor_ratio = cfg.get('point', 'monitor_ratio')
    is_merge = json.loads(cfg.get('screen', 'is_merge'))
    is_show_frame = int(show_frame) == 1
    is_mouse_follow = int(mouse_follow) == 1
    process_ratio = float(fps_ratio)
    monitor_ratio = float(monitor_ratio)
    is_merge = int(is_merge) == 1

    screen_width = int(cfg.get("screen", "screen_width"))
    screen_height = int(cfg.get("screen", "screen_height"))
    layout = json.loads(cfg.get("screen", "layout"))

    light = int(point_light)

    if process_ratio > 1:
        process_ratio = 1
    pts1 = np.array(json.loads(cfg.get('correct', 'position1')))
    pts2 = np.array(json.loads(cfg.get('correct', 'position2')))

    global MOUSEHANDLER
    MOUSEHANDLER = MultiScreenMouseEvent(screen_width, screen_height, layout, speed_mode=True)

    MouseVideo.start_mouse_follow(mouse_follow_callback, pts1, pts2, point_area, video_size, light,
                                  is_show_frame, is_mouse_follow, process_ratio, monitor_ratio, screen_width, screen_height, mousehandler=MOUSEHANDLER)
    #thread = Thread(target=start_mouse_follow)
    #thread.start()

def mouse_follow_callback(flag):
    global gl_win
    if flag == True:
        btn_disable(DISABLED, NORMAL)
        print_info("打开激光笔成功")
        gl_win.iconify()
    else:
        btn_disable(NORMAL, DISABLED)
        print_info("打开摄像头失败")

def open_point():
    if MouseVideo.is_running() == False:
        btn_disable(DISABLED, DISABLED)
        thread = Thread(target=start_open_point)
        thread.start()

def keyboard_listen():
    global gl_keyboard_open
    global gl_keyboard_close
    gl_keyboard_open = Thread(target=start_open_listener)
    gl_keyboard_open.start()
    gl_keyboard_close = Thread(target=start_close_listener)
    gl_keyboard_close.start()

def start_open_listener():
    keyboard.add_hotkey('ctrl+alt+z', open_point)
    keyboard.wait('ctrl+shift+alt+esc+z')

def start_close_listener():
    keyboard.add_hotkey('ctrl+alt+x', close_point)
    keyboard.wait('ctrl+shift+alt+esc+x')

def stop_keyboard_listen():
    global gl_keyboard_open
    global gl_keyboard_close
    _async_raise(gl_keyboard_open.ident, SystemExit)
    _async_raise(gl_keyboard_close.ident, SystemExit)

def _async_raise(tid, exctype):

    """raises the exception, performs cleanup if needed"""

    tid = ctypes.c_long(tid)
    if not inspect.isclass(exctype):
        exctype = type(exctype)
    res = ctypes.pythonapi.PyThreadState_SetAsyncExc(tid, ctypes.py_object(exctype))
    if res == 0:
        raise ValueError("invalid thread id")
    elif res != 1:
        # """if it returns a number greater than one, you're in trouble,
        # and you should call it again with exc=NULL to revert the effect"""
        ctypes.pythonapi.PyThreadState_SetAsyncExc(tid, None)
        raise SystemError("PyThreadState_SetAsyncExc failed")

def open_udp_service():
    thread = Thread(target=start_udp_service)
    thread.start()


gl_left_clicked = None
gl_left_long_clicked = None
gl_left_long_clicked_release = None
gl_left_double_clicked = None
gl_right_clicked = None
gl_right_long_clicked = None
gl_right_long_clicked_release = None
gl_right_double_clicked = None
gl_page_up_clicked = None
gl_page_down_clicked = None
gl_switch_clicked = None
gl_audio_clicked = None
def start_udp_service():
    global gl_left_clicked
    global gl_left_long_clicked
    global gl_left_long_clicked_release
    global gl_left_double_clicked
    global gl_right_clicked
    global gl_right_long_clicked
    global gl_right_long_clicked_release
    global gl_right_double_clicked
    global gl_page_up_clicked
    global gl_page_down_clicked
    global gl_switch_clicked
    global gl_audio_clicked
    cf = ConfigParser()
    cf.read('config.ini', encoding='utf-8')
    gl_left_clicked = replaceWrap(cf.get('order', 'left_clicked'))
    gl_left_long_clicked = replaceWrap(cf.get('order', 'left_long_clicked'))
    gl_left_long_clicked_release = replaceWrap(cf.get('order', 'left_long_clicked_release'))
    gl_left_double_clicked = replaceWrap(cf.get('order', 'left_double_clicked'))
    gl_right_clicked = replaceWrap(cf.get('order', 'right_clicked'))
    gl_right_long_clicked = replaceWrap(cf.get('order', 'right_long_clicked'))
    gl_right_long_clicked_release = replaceWrap(cf.get('order', 'right_long_clicked_release'))
    gl_right_double_clicked = replaceWrap(cf.get('order', 'right_double_clicked'))
    gl_page_up_clicked = replaceWrap(cf.get('order', 'page_up_clicked'))
    gl_page_down_clicked = replaceWrap(cf.get('order', 'page_down_clicked'))
    gl_switch_clicked = replaceWrap(cf.get('order', 'switch_clicked'))
    gl_audio_clicked = replaceWrap(cf.get('order', 'audio_clicked'))
    port = int(cf.get('udp_service', 'port'))
    UdpService.start_service(port, udp_revice)

def replaceWrap(str):
    return str.replace('\\r', '\r').replace('\\n', '\n')

def udp_revice(str):
    global MOUSEHANDLER
    global gl_left_clicked
    global gl_left_long_clicked
    global gl_left_long_clicked_release
    global gl_left_double_clicked
    global gl_right_clicked
    global gl_right_long_clicked
    global gl_right_long_clicked_release
    global gl_right_double_clicked
    global gl_page_up_clicked
    global gl_page_down_clicked
    global gl_switch_clicked
    global gl_audio_clicked
    print(datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S.%f"), "received udp msg:", str)
    if str == gl_left_clicked:
        #MouseEvent.mouse_left_click()
        MOUSEHANDLER.LeftClick()
    elif str == gl_left_long_clicked:
        #MouseEvent.mouse_left_down()
        MOUSEHANDLER.LeftDown()
    elif str == gl_left_long_clicked_release:
        #MouseEvent.mouse_left_up()
        MOUSEHANDLER.LeftUp()
    elif str == gl_left_double_clicked:
        #MouseEvent.mouse_left_dbclick()
        MOUSEHANDLER.LeftDoubleClick()
    elif str == gl_right_clicked:
        #MouseEvent.mouse_right_click()
        MOUSEHANDLER.RightClick()
    elif str == gl_right_long_clicked:
        #MouseEvent.mouse_right_down()
        MOUSEHANDLER.RightDown()
    elif str == gl_right_long_clicked_release:
        #MouseEvent.mouse_right_up()
        MOUSEHANDLER.RightUp()
    elif str == gl_right_double_clicked:
        #MouseEvent.mouse_right_dbclick()
        MOUSEHANDLER.RightClick()
        MOUSEHANDLER.RightClick()
    elif str == gl_page_up_clicked:
        #MOUSEHANDLER.mouse_middle_up()
        MOUSEHANDLER.MouseWheel(2)
    elif str == gl_page_down_clicked:
        #MOUSEHANDLER.mouse_middle_down()
        MOUSEHANDLER.MouseWheel(-2)
    elif str == gl_switch_clicked:
        if MouseVideo.is_running() == True:
            close_point()
        else:
            open_point()
    elif str == gl_audio_clicked:
        volume_change()

def close_point():
    MouseVideo.stop_mouse_follow()
    btn_disable(NORMAL, DISABLED)
    print_info("关闭激光笔成功")

def print_info(info):
    global gl_info_label
    gl_info_label.config(text = info)

def btn_disable(disable_open_btn, disable_close_btn):
    global gl_open_btn
    global gl_close_btn
    gl_open_btn.config(state = disable_open_btn)
    gl_close_btn.config(state = disable_close_btn)

def close_win():
    global gl_win
    print_info("正在关闭激光笔...")
    MouseVideo.stop_mouse_follow()
    stop_keyboard_listen()
    UdpService.stop_service()
    #time.sleep(1)
    gl_win.destroy()

def show_win():
    global gl_open_btn
    global gl_close_btn
    global gl_info_label
    global gl_win
    ctypes.windll.user32.ShowWindow(ctypes.windll.kernel32.GetConsoleWindow(), 6)
    gl_win = tkinter.Tk()
    gl_win.geometry('420x160')
    gl_win.title('云和激光笔')
    gl_win.resizable(False, False)
    gl_open_btn = Button(gl_win, text='打开激光笔', width=14, height=2, bg='pink', command=open_point)
    gl_open_btn.place(x=70, y=40)
    gl_close_btn= Button(gl_win, text='关闭激光笔', width=14, height=2, bg='pink', command=close_point)
    gl_close_btn.place(x=220, y=40)
    gl_info_label = Label(gl_win, text='')
    gl_info_label.place(x=70, y=100)
    tip_open_label = Label(gl_win, text='打开激光笔快捷键：Ctrl+Alt+Z')
    tip_open_label.place(x=215, y=100)
    tip_close_label = Label(gl_win, text='关闭激光笔快捷键：Ctrl+Alt+X')
    tip_close_label.place(x=215, y=120)
    btn_disable(NORMAL, DISABLED)
    gl_win.protocol('WM_DELETE_WINDOW', close_win)
    keyboard_listen()
    open_udp_service()
    gl_win.mainloop()
    
gl_keyboard_open = None
gl_keyboard_close = None
gl_info_label = None
gl_open_btn = None
gl_close_btn = None
gl_win = None
if __name__ == "__main__":
    show_win()