﻿/*
 * MIT License
 *
 * Copyright (c) 2019 xiongziliang <771730766@qq.com>
 *
 * This file is part of ZLMediaKit(https://github.com/xiongziliang/ZLMediaKit).
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#include "mk_httpclient.h"

#include "Util/logger.h"
#include "Http/HttpDownloader.h"
#include "Http/HttpRequester.h"

using namespace std;
using namespace toolkit;
using namespace mediakit;

API_EXPORT mk_http_downloader API_CALL mk_http_downloader_create() {
    HttpDownloader::Ptr *obj(new HttpDownloader::Ptr(new HttpDownloader()));
    return (mk_http_downloader) obj;
}

API_EXPORT void API_CALL mk_http_downloader_release(mk_http_downloader ctx) {
    assert(ctx);
    HttpDownloader::Ptr *obj = (HttpDownloader::Ptr *) ctx;
    delete obj;
}

API_EXPORT void API_CALL mk_http_downloader_start(mk_http_downloader ctx, const char *url, const char *file, on_mk_download_complete cb, void *user_data) {
    assert(ctx && url && file);
    HttpDownloader::Ptr *obj = (HttpDownloader::Ptr *) ctx;
    (*obj)->setOnResult([cb, user_data](ErrCode code, const string &errMsg, const string &filePath) {
        if (cb) {
            cb(user_data, code, errMsg.data(), filePath.data());
        }
    });
    (*obj)->startDownload(url, file, false);
}


///////////////////////////////////////////HttpRequester/////////////////////////////////////////////
API_EXPORT mk_http_requester API_CALL mk_http_requester_create(){
    HttpRequester::Ptr *ret = new HttpRequester::Ptr(new HttpRequester);
    return ret;
}

API_EXPORT void API_CALL mk_http_requester_clear(mk_http_requester ctx){
    assert(ctx);
    HttpRequester::Ptr *obj = (HttpRequester::Ptr *)ctx;
    (*obj)->clear();
}

API_EXPORT void API_CALL mk_http_requester_release(mk_http_requester ctx){
    assert(ctx);
    HttpRequester::Ptr *obj = (HttpRequester::Ptr *)ctx;
    delete obj;
}

API_EXPORT void API_CALL mk_http_requester_set_method(mk_http_requester ctx,const char *method){
    assert(ctx);
    HttpRequester::Ptr *obj = (HttpRequester::Ptr *)ctx;
    (*obj)->setMethod(method);
}

template <typename C = StrCaseMap>
static C get_http_header( const char *response_header[]){
    C header;
    for (int i = 0; response_header[i] != NULL;) {
        auto key = response_header[i];
        auto value = response_header[i + 1];
        if (key && value) {
            i += 2;
            header.emplace(key,value);
            continue;
        }
        break;
    }
    return std::move(header);
}

API_EXPORT void API_CALL mk_http_requester_set_body(mk_http_requester ctx, mk_http_body body){
    assert(ctx && body);
    HttpRequester::Ptr *obj = (HttpRequester::Ptr *)ctx;
    HttpBody::Ptr *body_obj = (HttpBody::Ptr *)body;
    (*obj)->setBody(*body_obj);
}

API_EXPORT void API_CALL mk_http_requester_set_header(mk_http_requester ctx, const char *header[]){
    assert(ctx && header);
    auto header_obj = get_http_header(header);
    HttpRequester::Ptr *obj = (HttpRequester::Ptr *)ctx;
    (*obj)->setHeader(header_obj);
}

API_EXPORT void API_CALL mk_http_requester_add_header(mk_http_requester ctx,const char *key,const char *value,int force){
    assert(ctx && key && value);
    HttpRequester::Ptr *obj = (HttpRequester::Ptr *)ctx;
    (*obj)->addHeader(key,value,force);
}

API_EXPORT const char* API_CALL mk_http_requester_get_response_status(mk_http_requester ctx){
    assert(ctx);
    HttpRequester::Ptr *obj = (HttpRequester::Ptr *)ctx;
    return (*obj)->responseStatus().c_str();
}

API_EXPORT const char* API_CALL mk_http_requester_get_response_header(mk_http_requester ctx,const char *key){
    assert(ctx);
    HttpRequester::Ptr *obj = (HttpRequester::Ptr *)ctx;
    return (*obj)->response()[key].c_str();
}

API_EXPORT const char* API_CALL mk_http_requester_get_response_body(mk_http_requester ctx, int *length){
    assert(ctx);
    HttpRequester::Ptr *obj = (HttpRequester::Ptr *)ctx;
    if(length){
       *length = (*obj)->response().Content().size();
    }
    return (*obj)->response().Content().c_str();
}

API_EXPORT mk_parser API_CALL mk_http_requester_get_response(mk_http_requester ctx){
    assert(ctx);
    HttpRequester::Ptr *obj = (HttpRequester::Ptr *)ctx;
    return (mk_parser)&((*obj)->response());
}

API_EXPORT void API_CALL mk_http_requester_set_cb(mk_http_requester ctx,on_mk_http_requester_complete cb, void *user_data){
    assert(ctx && cb);
    HttpRequester::Ptr *obj = (HttpRequester::Ptr *)ctx;
    (*obj)->setOnResult([cb,user_data](const SockException &ex,const string &status,const StrCaseMap &header,const string &strRecvBody){
        cb(user_data, ex.getErrCode(),ex.what());
    });
}

API_EXPORT void API_CALL mk_http_requester_start(mk_http_requester ctx,const char *url, float timeout_second){
    assert(ctx && url && url[0] && timeout_second > 0);
    HttpRequester::Ptr *obj = (HttpRequester::Ptr *)ctx;
    (*obj)->sendRequest(url,timeout_second);
}

